import asyncio

from sendr_qlog import LoggerContext

from mail.payments.payments.conf import settings

from .client import LogbrokerClient
from .enums import LogbrokerInstallation


class LogbrokerFactory:
    def __init__(self, logger: LoggerContext):
        self._clients: dict = {}
        self._lock = asyncio.Lock()
        self._logger = logger

    @property
    def logger(self):
        return self._logger

    async def get_client(self, installation: LogbrokerInstallation) -> LogbrokerClient:
        async with self._lock:
            if installation not in self._clients:
                if installation == LogbrokerInstallation.MAIN:
                    kwargs = {
                        'host': settings.LB_MAIN_HOST,
                        'port': settings.LB_MAIN_PORT,
                    }
                else:
                    kwargs = {
                        'host': settings.LB_CROSS_DC_HOST,
                        'port': settings.LB_CROSS_DC_PORT,
                    }
                lb = LogbrokerClient(logger=self._logger, **kwargs)
                await lb.run()
                self._clients[installation] = lb
        return self._clients[installation]

    async def close(self):
        for client in self._clients:
            await client.close()
