from sqlalchemy import func

from sendr_aiopg import BaseMapperCRUD
from sendr_aiopg.query_builder import CRUDQueries

from mail.payments.payments.core.entities.common import CommonData
from mail.payments.payments.storage.db.tables import common_data as t_common_data
from mail.payments.payments.utils.db import SelectableDataMapper, TableDataDumper


class CommonDataDataMapper(SelectableDataMapper):
    entity_class = CommonData
    selectable = t_common_data


class CommonDataDataDumper(TableDataDumper):
    entity_class = CommonData
    table = t_common_data


class CommonDataMapper(BaseMapperCRUD[CommonData]):
    model = CommonData
    name = 'common_data'
    _builder = CRUDQueries(
        t_common_data,
        id_fields=('common_data_id',),
        mapper_cls=CommonDataDataMapper,
        dumper_cls=CommonDataDataDumper,
    )

    async def create(self, obj: CommonData) -> CommonData:
        obj.created = func.now()
        return await super().create(obj, ignore_fields=self._builder.id_fields + ('created',))

    async def get(self, common_data_id: int) -> CommonData:
        query, mapper = self._builder.select(id_values=(common_data_id,))
        return mapper(await self._query_one(query, raise_=CommonData.DoesNotExist))

    async def save(self, obj: CommonData) -> CommonData:
        return await super().save(obj, ignore_fields=self._builder.id_fields + ('created',))
