from typing import AsyncIterable

from sendr_aiopg.query_builder import CRUDQueries

from mail.payments.payments.core.entities.manager import Manager
from mail.payments.payments.storage.db.tables import managers as t_managers
from mail.payments.payments.storage.exceptions import ManagerNotFound
from mail.payments.payments.storage.mappers.base import BaseMapper
from mail.payments.payments.utils.db import SelectableDataMapper, TableDataDumper


class ManagerDataMapper(SelectableDataMapper):
    entity_class = Manager
    selectable = t_managers


class ManagerDataDumper(TableDataDumper):
    entity_class = Manager
    table = t_managers


class ManagerMapper(BaseMapper):
    name = 'manager'
    _builder = CRUDQueries(
        base=t_managers,
        id_fields=('uid',),
        dumper_cls=ManagerDataDumper,
        mapper_cls=ManagerDataMapper,
    )

    async def get(self, uid: int) -> Manager:
        query, mapper = self._builder.select(id_values=(uid,))
        return mapper(await self._query_one(query, raise_=ManagerNotFound))

    async def find(self) -> AsyncIterable[Manager]:
        query, mapper = self._builder.select()
        async for row in self._query(query):
            yield mapper(row)

    async def create(self, manager: Manager) -> Manager:
        query, mapper = self._builder.insert(manager)
        return mapper(await self._query_one(query))
