from sqlalchemy import update
from sqlalchemy.sql.base import Executable

from sendr_aiopg.types import OptException

from mail.payments.payments.storage.db.tables import serials as t_serials


class SerialMixin:
    def _acquire_serial_query(self, uid: int, column: str) -> Executable:
        values = {column: getattr(t_serials.c, column) + 1}
        return (
            update(t_serials).
            where(t_serials.c.uid == uid).
            values(**values).
            returning(*t_serials.c)
        )

    async def _acquire_serial(self, uid: int, column: str, raise_: OptException = None) -> int:
        query = self._acquire_serial_query(uid, column)
        return (await self._query_one(query, raise_=raise_))[column] - 1  # type: ignore

    async def _acquire_revision(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_revision', raise_=raise_)

    async def _acquire_order_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_order_id', raise_=raise_)

    async def _acquire_subscription_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_subscription_id', raise_=raise_)

    async def _acquire_customer_subscription_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_customer_subscription_id', raise_=raise_)

    async def _acquire_tx_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_tx_id', raise_=raise_)

    async def _acquire_product_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_product_id', raise_=raise_)

    async def _acquire_shop_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_shop_id', raise_=raise_)

    async def _acquire_image_id(self, uid: int, raise_: OptException = None) -> int:
        return await self._acquire_serial(uid, 'next_image_id', raise_=raise_)
