from sendr_aiopg.data_mapper import TimeDumper

from mail.payments.payments.core.entities.enums import ReceiptType
from mail.payments.payments.core.entities.order import Order, OrderData, OriginalOrderInfo
from mail.payments.payments.storage.db.tables import orders as t_orders
from mail.payments.payments.utils.db import SelectableDataMapper, TableDataDumper


class OrderDataMapper(SelectableDataMapper):
    entity_class = Order
    selectable = t_orders

    @staticmethod
    def map_data(data: dict) -> OrderData:
        return OrderData(
            trust_form_name=data.get('trust_form_name'),
            trust_template=data.get('trust_template'),
            multi_max_amount=data.get('multi_max_amount'),
            multi_issued=data.get('multi_issued', 0),
            meta=data.get('meta'),
            offline_prolongation_amount=data.get('offline_prolongation_amount'),
            service_data=data.get('service_data'),
            turboapp_id=data.get('turboapp_id'),
            tsid=data.get('tsid'),
            psuid=data.get('psuid'),
            receipt_type=ReceiptType(data.get('receipt_type', ReceiptType.COMPLETE)),
            fast_moderation=data.get('fast_moderation', False),
            recurrent=data.get('recurrent', False),
            without_3ds=data.get('without_3ds', False),
            version=data.get('version', 1),
        )


class OrderDataDumper(TableDataDumper, TimeDumper):
    entity_class = Order
    table = t_orders


class OriginalOrderInfoMapper(SelectableDataMapper):
    entity_class = OriginalOrderInfo
    selectable = t_orders
