from sendr_aiopg.query_builder import CRUDQueries

from mail.payments.payments.core.entities.user import User
from mail.payments.payments.storage.db.tables import users as t_users
from mail.payments.payments.storage.exceptions import UserNotFound
from mail.payments.payments.storage.mappers.base import BaseMapper
from mail.payments.payments.utils.db import SelectableDataMapper, TableDataDumper


class UserDataMapper(SelectableDataMapper):
    entity_class = User
    selectable = t_users


class UserDataDumper(TableDataDumper):
    entity_class = User
    table = t_users


class UserMapper(BaseMapper):
    name = 'user'
    _builder = CRUDQueries(
        base=t_users,
        id_fields=('uid',),
        dumper_cls=UserDataDumper,
        mapper_cls=UserDataMapper,
    )

    async def get(self, uid: int) -> User:
        query, mapper = self._builder.select(id_values=(uid,))
        return mapper(await self._query_one(query, raise_=UserNotFound))

    async def create(self, user: User) -> User:
        query, mapper = self._builder.insert(user)
        return mapper(await self._query_one(query))
