import asyncio
from typing import Optional

from aiohttp import web
from sendr_writers.base.pusher import CommonPushers, Pusher

from mail.payments.payments.conf import settings


class PaymentsPushers(CommonPushers):
    def __init__(self, loop=None):
        self._loop = loop or asyncio.get_event_loop()
        self.log = self._make_pusher(settings.ORDER_FILE_PATH, True)
        self.response_log = self._make_pusher(
            settings.RESPONSE_FILE_PATH,
            settings.WRITE_RESPONSE_LOG,
            compress_on_backup=settings.COMPRESS_RESPONSE_LOG,
        )

    def _make_pusher(
        self, log_path: str, write_on_disk: bool, compress_on_backup: bool = False
    ) -> Optional[Pusher]:
        if write_on_disk:
            return Pusher(
                log_path,
                settings.WRITER_ROTATE_INTERVAL,
                settings.WRITER_BACKUP_COUNT,
                loop=self._loop,
                compress_on_backup=compress_on_backup,
            )
        return None

    async def close(self, app: web.Application) -> None:
        for pusher in (self.log, self.response_log):
            if pusher is not None:
                await pusher.close()
