from mail.payments.payments.core.actions.order.abandon_terminate import AbandonTerminateOrderAction
from mail.payments.payments.core.entities.worker import WorkerType
from mail.payments.payments.storage.exceptions import OrderNotFound
from mail.payments.payments.taskq.workers.base import BaseWorker
from mail.payments.payments.utils.helpers import copy_context


class AbandonTerminator(BaseWorker):
    worker_type = WorkerType.ABANDON_TERMINATOR

    @copy_context
    async def process_task(self):
        async with self.storage_context(transact=True) as storage:
            try:
                order = await storage.order.get_abandoned_order(for_update=True)
            except OrderNotFound:
                return self.PROCESS_TASK_WITH_PAUSE

            AbandonTerminateOrderAction.context.storage = storage
            await AbandonTerminateOrderAction(order=order, uid=order.uid).run()

            return self.PROCESS_TASK_WITH_NO_PAUSE
