from psycopg2.errors import LockNotAvailable

from sendr_taskqueue import BaseActionStorageWorker

from mail.payments.payments.core.actions.arbitrage.escalate import StartEscalateAction
from mail.payments.payments.core.actions.arbitrage.notify import NotifyArbitrageAction
from mail.payments.payments.core.actions.order.clear import ClearByIdsOrderAction
from mail.payments.payments.core.actions.order.clear_unhold import CoreClearUnholdOrderAction
from mail.payments.payments.core.actions.order.download_image import DownloadImageAction
from mail.payments.payments.core.actions.order.send_to_history import SendToHistoryOrderAction
from mail.payments.payments.core.actions.report import CreateReportAction
from mail.payments.payments.core.actions.tlog.customer_subscription import ExportCustomerSubscriptionToTLogAction
from mail.payments.payments.core.actions.tlog.order import ExportOrderToTLogAction
from mail.payments.payments.core.actions.tlog.refund import ExportRefundToTLogAction
from mail.payments.payments.core.actions.transact_email import TransactEmailAction
from mail.payments.payments.core.entities.enums import PaidOrderStatType, TaskType, WorkerType
from mail.payments.payments.core.exceptions import (
    CoreInteractionConnectionTimeoutError, CoreInteractionFatalError, CoreInteractionRequestError,
    CoreInteractionResponseError
)
from mail.payments.payments.storage.logbroker.exceptions import BaseLogbrokerException
from mail.payments.payments.taskq.workers.base import BaseWorker
from mail.payments.payments.utils.stats import paid_orders_amount


class ActionWorker(BaseWorker, BaseActionStorageWorker):
    """Basic action worker"""
    task_type = TaskType.RUN_ACTION
    worker_type = WorkerType.ACTION_EXECUTOR

    retry_exceptions = (
        CoreInteractionFatalError,
        CoreInteractionRequestError,
        CoreInteractionResponseError,
        CoreInteractionConnectionTimeoutError,
        LockNotAvailable,  # https://st.yandex-team.ru/PAYBACK-913
        BaseLogbrokerException,  # https://st.yandex-team.ru/PAYBACK-913
    )

    actions = (
        TransactEmailAction,
        ClearByIdsOrderAction,
        CoreClearUnholdOrderAction,
        CreateReportAction,
        DownloadImageAction,
        SendToHistoryOrderAction,
        NotifyArbitrageAction,
        StartEscalateAction,
        TransactEmailAction,
        ExportOrderToTLogAction,
        ExportRefundToTLogAction,
        ExportCustomerSubscriptionToTLogAction
    )

    async def update_stats(self, _):
        async with self.storage_context() as storage:
            for type_ in PaidOrderStatType:
                count = await storage.order.paid_count(type_)
                paid_orders_amount.labels(type_.value).observe(count)
