from typing import Any, Optional

from sendr_taskqueue import BaseStorageWorker

from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.entities.task import Task
from mail.payments.payments.storage import Storage, StorageContext
from mail.payments.payments.utils.helpers import copy_context
from mail.payments.payments.utils.stats import queue_tasks_counter, queue_tasks_time


class BaseWorker(BaseStorageWorker):
    storage_context_cls = StorageContext

    async def process_action(self, action_cls: Any, params: Any) -> None:
        with queue_tasks_time.labels(self.worker_type.value).time:
            await super().process_action(action_cls, params)

    async def task_fail(self, reason: Optional[str], task: Task, storage: Storage) -> bool:
        queue_tasks_counter.labels('fail').inc()
        return await super().task_fail(reason, task, storage)

    async def task_done(self, task: Task, storage: Storage) -> bool:
        queue_tasks_counter.labels('done').inc()
        return await super().task_done(task, storage)

    @copy_context
    async def _run(self):
        BaseAction.context.request_id = self.request_id
        BaseAction.context.logger = self.logger
        BaseAction.context.db_engine = self.app.db_engine
        BaseAction.context.pushers = self.app.pushers
        BaseAction.context.crypto = self.app.crypto
        BaseAction.context.partner_crypto = self.app.partner_crypto
        BaseAction.context.lb_factory = self.app.lb_factory
        return await super()._run()
