from sendr_interactions import exceptions as interaction_errors

from mail.payments.payments.conf import settings
from mail.payments.payments.core.actions.worker.callback import CallbackWorkerAction
from mail.payments.payments.core.entities.task import TaskType
from mail.payments.payments.core.entities.worker import WorkerType
from mail.payments.payments.core.exceptions import CoreInteractionConnectionTimeoutError
from mail.payments.payments.taskq.workers.base import BaseWorker


class CallbackSender(BaseWorker):
    worker_type = WorkerType.CALLBACK_SENDER
    retry_exceptions = (
        CoreInteractionConnectionTimeoutError,
        interaction_errors.InteractionResponseError
    )
    suppress_exceptions = (
        CoreInteractionConnectionTimeoutError,
        interaction_errors.InteractionResponseError
    )
    max_retries = settings.MERCHANT_CALLBACK_RETRIES_COUNT
    task_action_mapping = {
        TaskType.API_CALLBACK: CallbackWorkerAction,
    }
