from mail.payments.payments.core.actions.customer_subscription.sync import SyncCustomerSubscriptionAction
from mail.payments.payments.core.entities.worker import WorkerType
from mail.payments.payments.storage.exceptions import CustomerSubscriptionNotFound
from mail.payments.payments.taskq.workers.base import BaseWorker
from mail.payments.payments.utils.helpers import copy_context


class CustomerSubscriptionUpdater(BaseWorker):
    worker_type = WorkerType.CUSTOMER_SUBSCRIPTION_UPDATER
    pause_period = 10

    @copy_context
    async def process_task(self) -> bool:
        async with self.storage_context(transact=True) as storage:
            try:
                customer_subscription = await storage.customer_subscription.get_for_check()
            except CustomerSubscriptionNotFound:
                self.logger.debug('No customer subscriptions for update.')
                return False

            SyncCustomerSubscriptionAction.context.storage = storage
            await SyncCustomerSubscriptionAction(
                uid=customer_subscription.uid,
                order_id=customer_subscription.order_id,
            ).run()
            return True
