from mail.payments.payments.core.actions.update_transaction import UpdateTransactionAction
from mail.payments.payments.core.entities.worker import WorkerType
from mail.payments.payments.storage.exceptions import TransactionNotFound
from mail.payments.payments.taskq.workers.base import BaseWorker
from mail.payments.payments.utils.helpers import copy_context
from mail.payments.payments.utils.stats import open_transaction_gauge, queue_tasks_time


class TransactionUpdater(BaseWorker):
    worker_type = WorkerType.TRANSACTION_UPDATER

    async def update_stats(self, _):
        async with self.storage_context() as storage:
            unfinished = await storage.transaction.count_unfinished()
            open_transaction_gauge.observe(unfinished)

    @copy_context
    async def process_task(self):
        async with self.storage_context(transact=True) as storage:
            with queue_tasks_time.labels(self.worker_type.value).time:
                try:
                    tx = await storage.transaction.get_for_check()
                except TransactionNotFound:
                    return False
                UpdateTransactionAction.context.storage = storage
                await UpdateTransactionAction(transaction=tx).run()
                return True
