from datetime import date, datetime
from typing import Optional

from dateutil import parser

from sendr_utils import utcnow  # noqa


def dt_json_dict(items):
    return {
        k: v.isoformat() if isinstance(v, datetime) else v
        for k, v in items
    }


def parse_dt(value):
    if not value or not isinstance(value, str):
        return value

    try:
        return parser.parse(value)
    except Exception:
        return None


def date_to_str_optional(date_: Optional[date]) -> Optional[str]:
    if date_ is None:
        return None
    return date_.isoformat()
