class Runnable:
    def __init__(self):
        self._running = False

    def _clear(self):
        raise NotImplementedError

    async def _run(self):
        raise NotImplementedError

    async def _close(self):
        raise NotImplementedError

    async def run(self, *args, **kwargs):
        if self._running:
            return

        await self._run()
        self._running = True

    async def close(self, *args, **kwargs):
        if not self._running:
            return

        await self._close()
        self._clear()
        self._running = False

    async def __aenter__(self):
        await self.run()
        return self

    async def __aexit__(self, exc_type, exc, tb):
        await self.close()
