import cachetools
from ticket_parser2.api.v1 import BlackboxClientId
from tvm2 import TVM2Qloud as BaseTVM2Qloud
from tvmauth import TvmClient, TvmToolClientSettings  # type: ignore

from mail.payments.payments.conf import settings
from mail.payments.payments.utils.environment import APPLICATION_ENVIRONMENT


class TVM2Qloud(BaseTVM2Qloud):
    _cache: cachetools.TTLCache = cachetools.TTLCache(128, 10)

    @cachetools.cached(cache=_cache)
    def get_service_tickets(self, *destinations):
        return super().get_service_tickets(*destinations)


class CachedClient(TvmClient):
    _cache: cachetools.TTLCache = cachetools.TTLCache(128, 10)

    @cachetools.cached(cache=_cache)
    def get_service_ticket_for(self, alias=None, tvm_id=None):
        return super().get_service_ticket_for(alias, tvm_id)


def get_tvm2_client() -> TvmClient:
    # Deploy environment
    if APPLICATION_ENVIRONMENT == 'deploy':
        return CachedClient(
            TvmToolClientSettings(
                self_alias=settings.TVM_CLIENT
            )
        )

    return TVM2Qloud(
        client_id=settings.TVM_CLIENT,
        blackbox_client=BlackboxClientId.Prod,
        api_url=f'http://{settings.TVM_HOST}:{settings.TVM_PORT}/tvm'
    )
