OWNER(g:payments)

PY3_LIBRARY()

PEERDIR(
    contrib/python/aiofiles
    contrib/python/aiosocksy
    contrib/python/cryptography
    contrib/python/marshmallow-enum/py2
    contrib/python/Pillow
    contrib/python/pycrypto
    contrib/python/PyJWT
    contrib/python/pytz
    contrib/python/transliterate
    contrib/python/ujson
    contrib/python/uvloop
    contrib/python/xhtml2pdf
    contrib/python/xmltodict
    devtools/experimental/tvm2
    library/python/deprecated/ticket_parser2
    library/python/tvmauth
    library/python/resource
    mail/contrib/backoff
    mail/payments/protos
    mail/payments/templates
    mail/python/sendr-qtools
)

PY_SRCS(
    __init__.py
    api/app.py
    api/exceptions.py
    api/handlers/arbitrage/__init__.py
    api/handlers/arbitrage/order.py
    api/handlers/bank_requisites.py
    api/handlers/base.py
    api/handlers/callback.py
    api/handlers/category.py
    api/handlers/common_data.py
    api/handlers/customer_subscription.py
    api/handlers/document.py
    api/handlers/external/__init__.py
    api/handlers/external/order.py
    api/handlers/graph.py
    api/handlers/internal/__init__.py
    api/handlers/internal/base.py
    api/handlers/internal/customer_subscription.py
    api/handlers/internal/merchant.py
    api/handlers/internal/order.py
    api/handlers/internal/service.py
    api/handlers/internal/subscription.py
    api/handlers/merchant.py
    api/handlers/monitoring.py
    api/handlers/offer.py
    api/handlers/order.py
    api/handlers/report.py
    api/handlers/sdk/__init__.py
    api/handlers/sdk/order.py
    api/handlers/service.py
    api/handlers/shop.py
    api/handlers/subscription.py
    api/handlers/testing.py
    api/handlers/user_role.py
    api/middlewares.py
    api/response.py
    api/routes/arbitrage.py
    api/routes/base.py
    api/routes/external.py
    api/routes/internal.py
    api/routes/sdk.py
    api/routes/testing.py
    api/routes/v1.py
    api/schemas/arbitrage/order.py
    api/schemas/bank_requisites.py
    api/schemas/base.py
    api/schemas/category.py
    api/schemas/common_data.py
    api/schemas/customer_subscription.py
    api/schemas/document.py
    api/schemas/error.py
    api/schemas/external/__init__.py
    api/schemas/external/order.py
    api/schemas/fields.py
    api/schemas/functionality.py
    api/schemas/internal/__init__.py
    api/schemas/internal/customer_subscription.py
    api/schemas/internal/merchant.py
    api/schemas/internal/order.py
    api/schemas/internal/service.py
    api/schemas/keyset.py
    api/schemas/mcc.py
    api/schemas/merchant.py
    api/schemas/merchant_update.py
    api/schemas/mixins.py
    api/schemas/moderation.py
    api/schemas/order.py
    api/schemas/order_customer_subscription.py
    api/schemas/path.py
    api/schemas/report.py
    api/schemas/sdk/__init__.py
    api/schemas/sdk/order.py
    api/schemas/service.py
    api/schemas/shop.py
    api/schemas/subscription.py
    api/schemas/transaction.py
    api/schemas/user_role.py
    api_admin/app.py
    api_admin/middlewares.py
    api_admin/handlers/analytics.py
    api_admin/handlers/base.py
    api_admin/handlers/change_log.py
    api_admin/handlers/document.py
    api_admin/handlers/idm.py
    api_admin/handlers/manager.py
    api_admin/handlers/merchant.py
    api_admin/handlers/order.py
    api_admin/handlers/service.py
    api_admin/handlers/transaction.py
    api_admin/routes/idm.py
    api_admin/routes/ping.py
    api_admin/routes/v1.py
    api_admin/routes/v2.py
    api_admin/schemas/analytics.py
    api_admin/schemas/change_log.py
    api_admin/schemas/idm.py
    api_admin/schemas/manager.py
    api_admin/schemas/merchant.py
    api_admin/schemas/moderation.py
    api_admin/schemas/order.py
    api_admin/schemas/service.py
    api_admin/schemas/transaction.py
    api_sdk/app.py
    api_sdk/handlers/base.py
    api_sdk/handlers/order.py
    api_sdk/middlewares.py
    api_sdk/routes/monitoring.py
    api_sdk/routes/v1.py
    api_sdk/schemas/order.py
    api_sdk/schemas/path.py
    commands/__init__.py
    commands/create_default_shops.py
    commands/create_merchant.py
    commands/create_service.py
    commands/create_service_client.py
    commands/init_partner.py
    commands/init_user_roles.py
    commands/merchant_balance_recreate.py
    commands/merchant_balance_update.py
    commands/merchant_block.py
    commands/merchant_orders_stats.py
    commands/run_action.py
    commands/runadminserver.py
    commands/runsdkserver.py
    commands/runserver.py
    commands/runworkers.py
    commands/sql_create.py
    commands/start_moderation.py
    commands/update_merchant.py
    conf.py
    core/actions/arbitrage/consultation.py
    core/actions/arbitrage/escalate.py
    core/actions/arbitrage/get_order.py
    core/actions/arbitrage/notify.py
    core/actions/arbitrage/verdict.py
    core/actions/base/action.py
    core/actions/base/db.py
    core/actions/base/merchant.py
    core/actions/category.py
    core/actions/common_data.py
    core/actions/contract.py
    core/actions/customer_subscription/__init__.py
    core/actions/customer_subscription/cancel.py
    core/actions/customer_subscription/create.py
    core/actions/customer_subscription/get.py
    core/actions/customer_subscription/get_list.py
    core/actions/customer_subscription/pay.py
    core/actions/customer_subscription/sync.py
    core/actions/document.py
    core/actions/get_oauth.py
    core/actions/init_client.py
    core/actions/init_products.py
    core/actions/init_submerchant.py
    core/actions/interactions/bank_requisites.py
    core/actions/interactions/developer.py
    core/actions/interactions/so.py
    core/actions/interactions/trust.py
    core/actions/interactions/yandex_pay_admin.py
    core/actions/manager/analytics.py
    core/actions/manager/base.py
    core/actions/manager/change_log.py
    core/actions/manager/document.py
    core/actions/manager/merchant.py
    core/actions/manager/order.py
    core/actions/manager/role.py
    core/actions/manager/service.py
    core/actions/manager/transaction.py
    core/actions/merchant/balance_update.py
    core/actions/merchant/block.py
    core/actions/merchant/check_roles.py
    core/actions/merchant/check_uid_match.py
    core/actions/merchant/create.py
    core/actions/merchant/create_entity.py
    core/actions/merchant/data_update.py
    core/actions/merchant/draft.py
    core/actions/merchant/functionality.py
    core/actions/merchant/get.py
    core/actions/merchant/get_acquirer.py
    core/actions/merchant/get_by_key.py
    core/actions/merchant/get_mcc.py
    core/actions/merchant/graph.py
    core/actions/merchant/oauth_complete.py
    core/actions/merchant/oauth_delete.py
    core/actions/merchant/oauth_refresh.py
    core/actions/merchant/oauth_start.py
    core/actions/merchant/preregister.py
    core/actions/merchant/stats.py
    core/actions/merchant/suggest.py
    core/actions/merchant/token.py
    core/actions/merchant/update.py
    core/actions/mixins/auth_service_merchant.py
    core/actions/mixins/callback_task.py
    core/actions/mixins/moderation.py
    core/actions/mixins/notify.py
    core/actions/moderation.py
    core/actions/monitoring/__init__.py
    core/actions/monitoring/base.py
    core/actions/monitoring/ping_db.py
    core/actions/offer.py
    core/actions/order/abandon_terminate.py
    core/actions/order/activate.py
    core/actions/order/base.py
    core/actions/order/cancel.py
    core/actions/order/clear.py
    core/actions/order/clear_unhold.py
    core/actions/order/create_from_multi.py
    core/actions/order/create_or_update.py
    core/actions/order/download_image.py
    core/actions/order/email.py
    core/actions/order/get.py
    core/actions/order/get_by_hash.py
    core/actions/order/get_list.py
    core/actions/order/get_timeline.py
    core/actions/order/get_trust_env.py
    core/actions/order/pay.py
    core/actions/order/pay_offline.py
    core/actions/order/receipt_close.py
    core/actions/order/refund.py
    core/actions/order/resize.py
    core/actions/order/send_to_history.py
    core/actions/order/sync.py
    core/actions/order/update_service_data.py
    core/actions/report.py
    core/actions/service.py
    core/actions/service_client.py
    core/actions/service_merchant/base.py
    core/actions/service_merchant/create.py
    core/actions/service_merchant/delete.py
    core/actions/service_merchant/get.py
    core/actions/service_merchant/update.py
    core/actions/shop/create_or_update.py
    core/actions/shop/get_list.py
    core/actions/shop/get_or_ensure_default.py
    core/actions/subscription/base.py
    core/actions/subscription/create.py
    core/actions/subscription/delete.py
    core/actions/subscription/get.py
    core/actions/subscription/get_list.py
    core/actions/testing/delete_user.py
    core/actions/tlog/__init__.py
    core/actions/tlog/customer_subscription.py
    core/actions/tlog/order.py
    core/actions/tlog/refund.py
    core/actions/tlog/schemas.py
    core/actions/tlog/write.py
    core/actions/transact_email.py
    core/actions/update_refund.py
    core/actions/update_transaction.py
    core/actions/user_role/base.py
    core/actions/user_role/create.py
    core/actions/user_role/delete.py
    core/actions/user_role/get.py
    core/actions/worker/callback.py
    core/actions/worker/moderation.py
    core/actions/worker/moderation_result_notify.py
    core/actions/worker/start_refund.py
    core/context.py
    core/entities/arbitrage.py
    core/entities/bank_requisites.py
    core/entities/category.py
    core/entities/change_log.py
    core/entities/client.py
    core/entities/common.py
    core/entities/customer_subscription.py
    core/entities/customer_subscription_transaction.py
    core/entities/document.py
    core/entities/enums.py
    core/entities/functionality.py
    core/entities/image.py
    core/entities/item.py
    core/entities/keyset.py
    core/entities/log.py
    core/entities/manager.py
    core/entities/mcc.py
    core/entities/merchant.py
    core/entities/merchant_oauth.py
    core/entities/merchant_preregistration.py
    core/entities/merchant_user.py
    core/entities/moderation.py
    core/entities/not_fetched.py
    core/entities/order.py
    core/entities/product.py
    core/entities/report.py
    core/entities/serial.py
    core/entities/service.py
    core/entities/shop.py
    core/entities/spark.py
    core/entities/subscription.py
    core/entities/task.py
    core/entities/transaction.py
    core/entities/user.py
    core/entities/user_role.py
    core/entities/userinfo.py
    core/entities/worker.py
    core/exceptions.py
    file_storage/__init__.py
    file_storage/yandex_pay_admin.py
    http_helpers/crypto.py
    http_helpers/partner_crypto.py
    interactions/__init__.py
    interactions/arbiter/__init__.py
    interactions/avatars/__init__.py
    interactions/balance/__init__.py
    interactions/balance/base.py
    interactions/balance/client.py
    interactions/balance/contract.py
    interactions/balance/entities.py
    interactions/balance/exceptions.py
    interactions/balance/offer.py
    interactions/balance/person.py
    interactions/balance_http/__init__.py
    interactions/base.py
    interactions/blackbox/__init__.py
    interactions/callback/__init__.py
    interactions/developer/__init__.py
    interactions/developer/exceptions.py
    interactions/exceptions.py
    interactions/floyd/__init__.py
    interactions/floyd/entities.py
    interactions/geobase/__init__.py
    interactions/kassa/__init__.py
    interactions/mds/__init__.py
    interactions/oauth/__init__.py
    interactions/ohio/__init__.py
    interactions/refs/__init__.py
    interactions/refs/exceptions.py
    interactions/search_wizard/__init__.py
    interactions/search_wizard/entities.py
    interactions/sender/__init__.py
    interactions/service/__init__.py
    interactions/so/__init__.py
    interactions/spark/__init__.py
    interactions/spark/exceptions.py
    interactions/spark/request.py
    interactions/spark/response.py
    interactions/spark_suggest/__init__.py
    interactions/spark_suggest/entities.py
    interactions/tinkoff/__init__.py
    interactions/trust/__init__.py
    interactions/trust/action.py
    interactions/trust/base.py
    interactions/trust/entities.py
    interactions/trust/exceptions.py
    interactions/trust/mcc.py
    interactions/trust/order.py
    interactions/trust/partner.py
    interactions/trust/payment.py
    interactions/trust/payment_methods.py
    interactions/trust/product.py
    interactions/trust/refund.py
    interactions/trust/subscription.py
    interactions/yandex_pay_admin/__init__.py
    interactions/yandex_pay_admin/entities.py
    interactions/yandex_pay_admin/exceptions.py
    interactions/yandex_pay_admin/schemas.py
    interactions/zora.py
    interactions/zora_images/__init__.py
    interactions/zora_images/exceptions.py
    manage.py
    schemas/functionality.py
    storage/__init__.py
    storage/db/tables.py
    storage/exceptions.py
    storage/logbroker/client.py
    storage/logbroker/consumers/base.py
    storage/logbroker/consumers/moderation.py
    storage/logbroker/enums.py
    storage/logbroker/exceptions.py
    storage/logbroker/factory.py
    storage/logbroker/producers/base.py
    storage/logbroker/producers/moderation.py
    storage/logbroker/producers/tlog.py
    storage/mappers/__init__.py
    storage/mappers/arbitrage.py
    storage/mappers/base.py
    storage/mappers/category.py
    storage/mappers/change_log.py
    storage/mappers/common_data.py
    storage/mappers/functionality.py
    storage/mappers/image.py
    storage/mappers/item.py
    storage/mappers/manager.py
    storage/mappers/manager_role.py
    storage/mappers/merchant/__init__.py
    storage/mappers/merchant/merchant.py
    storage/mappers/merchant/serialization.py
    storage/mappers/merchant_oauth.py
    storage/mappers/merchant_preregistration.py
    storage/mappers/mixins.py
    storage/mappers/moderation.py
    storage/mappers/order/order.py
    storage/mappers/order/serialization.py
    storage/mappers/product.py
    storage/mappers/report.py
    storage/mappers/serial.py
    storage/mappers/service/serialization.py
    storage/mappers/service/service.py
    storage/mappers/service/service_client.py
    storage/mappers/service/service_merchant.py
    storage/mappers/shop.py
    storage/mappers/subscription/__init__.py
    storage/mappers/subscription/customer_subscription.py
    storage/mappers/subscription/customer_subscription_transaction.py
    storage/mappers/subscription/subscription.py
    storage/mappers/task.py
    storage/mappers/transaction.py
    storage/mappers/user.py
    storage/mappers/user_role.py
    storage/mappers/worker.py
    storage/writers/__init__.py
    taskq/app.py
    taskq/workers/abandon_terminator.py
    taskq/workers/action_worker.py
    taskq/workers/base.py
    taskq/workers/callback_sender.py
    taskq/workers/customer_subscription_updater.py
    taskq/workers/merchant_data_updater.py
    taskq/workers/moderation.py
    taskq/workers/moderation_result_notifier.py
    taskq/workers/oauth_token_updater.py
    taskq/workers/refund_starter.py
    taskq/workers/refund_updater.py
    taskq/workers/transaction_updater.py
    utils/cli.py
    utils/const.py
    utils/crypto.py
    utils/datetime.py
    utils/db.py
    utils/helpers.py
    utils/jinja.py
    utils/logging.py
    utils/runnable.py
    utils/stats.py
    utils/tvm2.py
    utils/environment.py
)

RESOURCE_FILES(
    settings/000-logging.conf
    settings/000-logging.conf.development
    settings/000-logging.conf.production
    settings/010-common.conf
    settings/010-common.conf.development
    settings/010-common.conf.production
    settings/010-common.conf.testing
    settings/020-interactions.conf
    settings/020-interactions.conf.development
    settings/020-interactions.conf.production
    settings/020-interactions.conf.testing
    settings/030-database.conf
    settings/040-tvm.conf
    settings/040-tvm.conf.development
    settings/040-tvm.conf.production
    settings/040-tvm.conf.testing
    settings/050-writer.conf
    settings/050-writer.conf.development
    settings/060-taskq.conf
    settings/070-logbroker.conf
    settings/070-logbroker.conf.development
    settings/070-logbroker.conf.production
    settings/070-logbroker.conf.testing
    settings/080-moderation.conf
    settings/090-filestorage.conf
    settings/100-test.conf
)

END()

RECURSE_FOR_TESTS(tests)
