CREATE OR REPLACE FUNCTION payments.check_no_more_than_one_active_transaction()
RETURNS TRIGGER LANGUAGE plpgsql AS $$
BEGIN
    IF NEW.status = 'active' AND (
        SELECT count(*)
          FROM payments.transactions
         WHERE (uid, order_id) = (NEW.uid, NEW.order_id)
           AND status IN ('active', 'held')
    ) > 0 THEN
        RAISE EXCEPTION 'Active transaction already exists for (uid = %s, order_id = %s)', NEW.uid, NEW.order_id;
    END IF;
    RETURN NEW;
END;
$$;
ALTER TABLE payments.merchants ADD COLUMN api_callback_url TEXT DEFAULT NULL;
