ALTER TABLE payments.products
    ADD COLUMN revision bigint default 1;
ALTER TABLE payments.products
    ALTER COLUMN revision DROP DEFAULT;

ALTER TABLE payments.transactions
    ADD COLUMN revision bigint default 1;
ALTER TABLE payments.transactions
    ALTER COLUMN revision DROP DEFAULT;


CREATE TYPE payments.operation_kind AS ENUM (
    'add-order',
    'add-refund',
    'start-payment',
    'end-payment'
);

CREATE TABLE payments.change_log (
    -- PK
    uid        bigint not null,
    revision   bigint not null,
    -- Data
    operation  payments.operation_kind not null,
    arguments  jsonb,
    info       jsonb,
    changed_at timestamptz default now()
);