ALTER TABLE payments.transactions
    ADD COLUMN updated timestamptz not null default now();

CREATE TYPE payments.task_type AS ENUM (
    'order_callback'
);

CREATE TYPE payments.task_state AS ENUM (
    'failed',
    'pending',
    'processing',
    'finished',
    'deleted',
    'cleanup'
);

CREATE TYPE payments.worker_type AS ENUM (
    'callback_sender',
    'transaction_updater'
);

CREATE TYPE payments.worker_state AS ENUM (
    'running',
    'shutdown',
    'failed',
    'cleanedup'
);

CREATE TABLE payments.tasks (
    task_id bigserial PRIMARY KEY,
    task_type payments.task_type not null,
    state payments.task_state not null,
    params jsonb,
    details jsonb,
    retries int not null default 0,
    run_at timestamptz not null default now(),
    created timestamptz not null default now(),
    updated timestamptz not null default now()
);

CREATE TABLE payments.workers (
    worker_id text PRIMARY KEY,
    worker_type payments.worker_type not null,
    host text not null,
    state payments.worker_state not null,
    heartbeat timestamptz,
    startup timestamptz,
    task_id bigint,
    FOREIGN KEY (task_id) REFERENCES payments.tasks (task_id)
);

ALTER TABLE payments.merchants
    ADD COLUMN client_id text,
    ADD COLUMN person_id text,
    ADD COLUMN contract_id text,
    ADD COLUMN submerchant_id text
;

UPDATE payments.merchants m
    SET client_id = (m.billing).client_id,
        person_id = (m.billing).person_id,
        contract_id = (m.billing).contract_id,
        submerchant_id = (m.billing).trust_submerchant_id
;
