ALTER TYPE payments.worker_type ADD VALUE 'moderation_reader';
ALTER TYPE payments.worker_type ADD VALUE 'moderation_writer';

ALTER TYPE payments.task_type ADD value 'start_moderation';

ALTER TYPE payments.operation_kind ADD value 'start-merchant-moderation';
ALTER TYPE payments.operation_kind ADD value 'end-merchant-moderation';

ALTER TABLE payments.merchants
    ADD COLUMN revision bigint NOT NULL DEFAULT 0,
    ADD COLUMN updated timestamptz not null default now();

CREATE TYPE payments.moderation_type AS enum (
    'merchant',
    'transaction'
);

CREATE TABLE payments.moderations (
    moderation_id bigserial PRIMARY KEY,
    moderation_type payments.moderation_type not null,
    uid bigint not null,
    revision bigint not null,
    approved boolean,
    reason text,
    created timestamptz not null default now(),
    updated timestamptz not null default now(),

    CONSTRAINT fk_moderations_on_merchants FOREIGN KEY (uid)
        REFERENCES payments.merchants
);

CREATE INDEX i_moderations_by_uid_revision_id_type
    ON payments.moderations (uid, revision, moderation_id, moderation_type);
