ALTER TABLE payments.moderations
    ADD COLUMN entity_id bigint, -- e. g. order_id
    ADD COLUMN reasons jsonb;

ALTER TABLE payments.merchants
    ADD COLUMN trustworthy BOOLEAN DEFAULT FALSE NOT NULL;

ALTER TYPE payments.moderation_type ADD VALUE 'order';

ALTER TYPE payments.pay_order_status ADD VALUE 'in_moderation';
ALTER TYPE payments.pay_order_status ADD VALUE 'moderation_negative';

ALTER TYPE payments.task_type ADD VALUE 'start_order_moderation';

ALTER TYPE payments.operation_kind ADD value 'start-order-moderation';
ALTER TYPE payments.operation_kind ADD value 'end-order-moderation';

-- search for order moderations and for merchant latest approved moderation
CREATE INDEX i_moderations_by__uid__type__entity_id__approved__revision
    ON payments.moderations (uid, moderation_type, entity_id, approved, revision);

DROP INDEX IF EXISTS payments.i_moderations_by_uid_revision_id_type;
