DROP TABLE IF EXISTS payments.service_connections CASCADE;
DROP TABLE IF EXISTS payments.services CASCADE;

CREATE TABLE payments.services (
  service_id BIGSERIAL PRIMARY KEY,
  name text NOT NULL DEFAULT '', -- it is for our purposes only, should not make any sense for outer world
  tvm_id BIGINT UNIQUE NOT NULL,
  api_callback_url text,
  order_moderation_enabled BOOLEAN NOT NULL DEFAULT TRUE,
  created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
  updated TIMESTAMPTZ NOT NULL DEFAULT NOW()
);

CREATE TABLE payments.service_merchant (
  service_merchant_id BIGSERIAL PRIMARY KEY,
  uid BIGINT NOT NULL,
  service_id BIGINT NOT NULL,
  enabled BOOLEAN NOT NULL DEFAULT FALSE,
-- entity_id could be called "merchant external id" - it is up to the service to interpret this column
-- we are going to be agnostic about nature of this column, except the fact this column somehow identifies
-- merchant on the side of service
  entity_id TEXT NOT NULL,
  description TEXT NOT NULL DEFAULT '',
  created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
  updated TIMESTAMPTZ NOT NULL DEFAULT NOW(),
-- service_merchant records should not be deleted in fact
  deleted BOOLEAN NOT NULL DEFAULT FALSE,

  CONSTRAINT fk_service_merchant_on_merchants FOREIGN KEY (uid) REFERENCES payments.merchants ON DELETE RESTRICT ,
  CONSTRAINT fk_service_merchant_on_services FOREIGN KEY (service_id) REFERENCES payments.services ON DELETE RESTRICT
);

CREATE UNIQUE INDEX i_service_merchant_by__uid__service_id__entity_id
    ON payments.service_merchant(uid, service_id, entity_id)
    WHERE NOT deleted;

ALTER TABLE payments.orders
  ADD COLUMN service_merchant_id BIGINT, -- allow null values
  ADD CONSTRAINT fk_orders_on_service_merchant
-- prevent order deletion even we do not want delete service_merchant records
    FOREIGN KEY (service_merchant_id) REFERENCES payments.service_merchant ON DELETE RESTRICT;
