ALTER TABLE payments.service_merchant
    RENAME TO service_merchants;

CREATE TABLE payments.service_clients (
    service_client_id BIGSERIAL PRIMARY KEY,
    service_id BIGINT,
    tvm_id BIGINT UNIQUE NOT NULL,
    api_callback_url TEXT,
    created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    updated TIMESTAMPTZ NOT NULL DEFAULT NOW(),

    CONSTRAINT fk_service_clients_on_services
        FOREIGN KEY (service_id) REFERENCES payments.services ON DELETE RESTRICT
);

INSERT INTO payments.service_clients (service_id, tvm_id, api_callback_url)
    SELECT service_id, tvm_id, api_callback_url
    FROM payments.services
;

ALTER TABLE payments.orders
    ADD COLUMN service_client_id BIGINT,
    ADD CONSTRAINT fk_orders_on_service_merchants
        FOREIGN KEY (service_merchant_id) REFERENCES payments.service_merchants ON DELETE RESTRICT;

UPDATE payments.orders o
    SET service_client_id = sc.service_client_id
    FROM payments.services s
    JOIN payments.service_clients sc
        ON s.service_id = sc.service_id
    JOIN payments.service_merchants sm
        ON s.service_id = sm.service_id
    WHERE o.service_merchant_id = sm.service_merchant_id
;
