CREATE TYPE payments.role AS ENUM (
    'admin',
    'assessor'
);

CREATE TABLE payments.managers (
    uid BIGINT PRIMARY KEY,
    domain_login TEXT NOT NULL,
    created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    updated TIMESTAMPTZ NOT NULL DEFAULT NOW()
);

CREATE TABLE payments.manager_role (
    manager_uid BIGINT NOT NULL,
    role payments.role NOT NULL,
    created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    updated TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    PRIMARY KEY (manager_uid, role),
    CONSTRAINT fk_merchant_uid_on_manager FOREIGN KEY (manager_uid) REFERENCES payments.managers (uid) ON DELETE CASCADE
)
