ALTER TABLE payments.merchants
	ADD COLUMN merchant_id TEXT DEFAULT NULL;


UPDATE payments.merchants
    SET merchant_id = CAST(uid AS TEXT) WHERE merchant_id IS NULL;


CREATE UNIQUE INDEX i_merchants_by_merchant_id
    ON payments.merchants (merchant_id);


CREATE TYPE payments.user_role AS ENUM (
    'owner',
    'admin',
    'operator',
    'viewer'
);


CREATE TABLE payments.users (
    uid BIGINT PRIMARY KEY,
    email TEXT,
    created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    updated TIMESTAMPTZ NOT NULL DEFAULT NOW()
);


CREATE TABLE payments.user_roles (
    uid BIGINT,
    merchant_id TEXT,
    role payments.user_role NOT NULL,
    created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    updated TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    PRIMARY KEY (uid, merchant_id),

    CONSTRAINT fk_user_roles_on_users
    FOREIGN KEY (uid) REFERENCES payments.users ON DELETE RESTRICT,

    CONSTRAINT fk_user_roles_on_merchants
    FOREIGN KEY (merchant_id) REFERENCES payments.merchants(merchant_id) ON DELETE RESTRICT
);
