CREATE TYPE payments.period_unit AS ENUM ('S', 'D', 'W', 'M', 'Y');
CREATE TABLE payments.subscriptions
(
    uid                 BIGINT                   NOT NULL,
    subscription_id     BIGINT                   NOT NULL,
    service_merchant_id BIGINT                   NULL,
    service_client_id   BIGINT                   NULL,
    product_uuid        TEXT                     NOT NULL UNIQUE,
    title               TEXT                     NOT NULL,
    fiscal_title        TEXT                     NOT NULL,
    nds                 payments.nds             NOT NULL,
    period_amount       INTEGER                  NOT NULL,
    period_units        payments.period_unit     NOT NULL,
    trial_period_amount INTEGER,
    trial_period_units  payments.period_unit,
    prices              JSONB                    NOT NULL,
    revision            BIGINT                   NOT NULL,
    created             TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
    updated             TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
    PRIMARY KEY (uid, subscription_id),
    FOREIGN KEY (uid) REFERENCES payments.merchants (uid) ON DELETE RESTRICT,
    FOREIGN KEY (service_merchant_id) REFERENCES payments.service_merchants (service_merchant_id) ON DELETE RESTRICT,
    FOREIGN KEY (service_client_id) REFERENCES payments.service_clients (service_client_id) ON DELETE RESTRICT
);

ALTER TABLE payments.serials
    ADD next_subscription_id BIGINT NOT NULL DEFAULT 1;

ALTER TYPE payments.moderation_type ADD VALUE 'subscription';
ALTER TYPE payments.task_type ADD VALUE 'start_subscription_moderation';
ALTER TYPE payments.operation_kind ADD value 'start-subscription-moderation';
ALTER TYPE payments.operation_kind ADD value 'end-subscription-moderation';



