CREATE TABLE payments.customer_subscriptions
(
    customer_subscription_id BIGINT                   NOT NULL,
    uid                      BIGINT                   NOT NULL,
    subscription_id          BIGINT                   NOT NULL,
    service_merchant_id      BIGINT                   NULL,
    service_client_id        BIGINT                   NULL,
    order_id                 BIGINT                   NULL,

    user_ip                  TEXT                     NOT NULL,
    region_id                BIGINT                   NOT NULL,
    quantity                 BIGINT                   NOT NULL,
    enabled                  BOOLEAN                  NOT NULL,
    time_until               TIMESTAMP WITH TIME ZONE NOT NULL,
    time_finish              TIMESTAMP WITH TIME ZONE,

    created                  TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
    updated                  TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),

    PRIMARY KEY (uid, customer_subscription_id),
    FOREIGN KEY (uid) REFERENCES payments.merchants (uid) ON DELETE RESTRICT,
    FOREIGN KEY (uid, subscription_id) REFERENCES payments.subscriptions (uid, subscription_id) ON DELETE RESTRICT,
    FOREIGN KEY (service_merchant_id) REFERENCES payments.service_merchants (service_merchant_id) ON DELETE RESTRICT,
    FOREIGN KEY (service_client_id) REFERENCES payments.service_clients (service_client_id) ON DELETE RESTRICT
);

ALTER TABLE payments.orders
    ADD COLUMN customer_subscription_id BIGINT NULL DEFAULT NULL,
    ADD CONSTRAINT fk_orders_on_customer_subscriptions FOREIGN KEY (uid, customer_subscription_id) REFERENCES payments.customer_subscriptions (uid, customer_subscription_id) ON DELETE RESTRICT;

CREATE INDEX i_orders_by_uid_customer_subscription_id
    ON payments.orders (uid, customer_subscription_id);

ALTER TABLE payments.subscriptions
    ADD COLUMN enabled BOOLEAN NOT NULL DEFAULT TRUE;

ALTER TABLE payments.serials
    ADD next_customer_subscription_id BIGINT NOT NULL DEFAULT 1;