CREATE TABLE payments.customer_subscription_transactions
(
    uid                      BIGINT                      NOT NULL,
    customer_subscription_id BIGINT                      NOT NULL,
    purchase_token           TEXT                        NOT NULL,
    payment_status           payments.transaction_status NOT NULL,
    data                     JSONB,
    created                  TIMESTAMP WITH TIME ZONE    NOT NULL,
    updated                  TIMESTAMP WITH TIME ZONE    NOT NULL,
    PRIMARY KEY (uid, customer_subscription_id, purchase_token),
    FOREIGN KEY (uid) REFERENCES payments.merchants (uid) ON DELETE RESTRICT,
    FOREIGN KEY (uid, customer_subscription_id) REFERENCES payments.customer_subscriptions (uid, customer_subscription_id) ON DELETE RESTRICT
);

ALTER TYPE payments.worker_type ADD VALUE 'customer_subscription_updater';