CREATE TABLE payments.merchant_oauths
(
    merchant_id             TEXT                     NOT NULL,
    encrypted_access_token  TEXT                     NOT NULL,
    encrypted_refresh_token TEXT                     NOT NULL,
    expires                 TIMESTAMP WITH TIME ZONE NOT NULL,
    poll                    BOOLEAN DEFAULT TRUE,
    created                 TIMESTAMP WITH TIME ZONE NOT NULL,
    updated                 TIMESTAMP WITH TIME ZONE NOT NULL,
    FOREIGN KEY (merchant_id) REFERENCES payments.merchants (merchant_id) ON DELETE CASCADE,
    PRIMARY KEY (merchant_id)
);

CREATE INDEX merchant_oauths_poll_expires_updated_index ON payments.merchant_oauths (poll, expires, updated);