ALTER TABLE payments.merchants
    ADD COLUMN dialogs_org_id text DEFAULT null;

CREATE TYPE payments.arbitrage_status AS ENUM ('consultation', 'escalate', 'complete', 'discard');

CREATE TABLE payments.arbitrages
(
    arbitrage_id    BIGSERIAL                NOT NULL,
    uid             BIGINT                   NOT NULL,
    order_id        BIGINT                   NOT NULL,
    refund_id       BIGINT,
    chat_id         TEXT,
    arbiter_chat_id TEXT,
    escalate_id     TEXT,
    status          payments.arbitrage_status,
    created         TIMESTAMP WITH TIME ZONE NOT NULL,
    updated         TIMESTAMP WITH TIME ZONE NOT NULL,
    PRIMARY KEY (arbitrage_id),
    FOREIGN KEY (uid, order_id) REFERENCES payments.orders (uid, order_id) ON DELETE RESTRICT,
    FOREIGN KEY (uid, refund_id) REFERENCES payments.orders (uid, order_id) ON DELETE RESTRICT
);

CREATE UNIQUE INDEX uk_arbitrage_single_active ON payments.arbitrages (uid, order_id) WHERE status in ('consultation', 'escalate');
