CREATE TABLE payments.shops
(
    uid        BIGINT                   NOT NULL,
    shop_id    BIGINT                   NOT NULL,
    name       TEXT                     NOT NULL,
    is_default BOOLEAN                  NOT NULL DEFAULT false,
    shop_type  payments.shop_type       NOT NULL DEFAULT 'prod'::payments.shop_type,

    settings   JSONB                    NOT NULL DEFAULT '{}'::JSONB,
    created    TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
    updated    TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),

    PRIMARY KEY (uid, shop_id),

    CONSTRAINT fk_shops_on_merchants FOREIGN KEY (uid)
        REFERENCES payments.merchants ON DELETE CASCADE
);

ALTER TABLE payments.serials
    ADD next_shop_id BIGINT NOT NULL DEFAULT 1;

ALTER TABLE payments.orders
    ADD COLUMN shop_id BIGINT DEFAULT NULL,
    ADD CONSTRAINT fk_orders_on_shops FOREIGN KEY (uid, shop_id)
        REFERENCES payments.shops (uid, shop_id) ON DELETE RESTRICT;

-- each merchant can have only one default shop
CREATE UNIQUE INDEX i_shops_default_unique
    ON payments.shops (uid, is_default) WHERE (is_default);

CREATE INDEX i_orders_by_uid_shop_id
    ON payments.orders (uid, shop_id);
