ALTER TABLE payments.orders ADD COLUMN acquirer payments.acquirer_type NULL DEFAULT NULL;

UPDATE payments.orders o
    SET acquirer = m.acquirer
    FROM payments.merchants m
    JOIN (
        SELECT t.uid, t.order_id FROM payments.orders orders
        JOIN payments.transactions t
            ON t.order_id = orders.order_id
            AND t.uid = orders.uid
        GROUP BY t.uid, t.order_id
        ) AS subq
      ON subq.uid = m.uid where o.uid = m.uid and o.order_id = subq.order_id
;

ALTER TABLE payments.subscriptions ADD COLUMN acquirer payments.acquirer_type NULL DEFAULT NULL;

UPDATE payments.subscriptions s
    SET acquirer = m.acquirer
    FROM payments.merchants m
    WHERE s.uid = m.uid
;
