CREATE TABLE payments.images (
    uid BIGINT REFERENCES payments.merchants (uid),
    image_id BIGINT,
    url TEXT NOT NULL,
    stored_path TEXT,
    md5 TEXT,
    sha256 TEXT,
    created TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    updated TIMESTAMPTZ NOT NULL DEFAULT NOW(),
    UNIQUE (uid, md5, sha256),
    PRIMARY KEY (uid, image_id),
    CONSTRAINT images_hashes CHECK (md5 IS NOT NULL and sha256 IS NOT NULL or md5 IS NULL and sha256 IS NULL)
);

ALTER TABLE payments.items
    ADD COLUMN image_id BIGINT,
    ADD CONSTRAINT fk_items_on_images FOREIGN KEY (uid, image_id) REFERENCES payments.images (uid, image_id);

ALTER TABLE payments.serials
    ADD next_image_id BIGINT NOT NULL DEFAULT 1;

CREATE INDEX idx_items_image_id ON payments.items (uid, image_id);
