-- Add uid column
ALTER TABLE payments.merchant_oauths ADD COLUMN uid BIGINT;

UPDATE payments.merchant_oauths SET uid = merchant_id::bigint;

ALTER TABLE payments.merchant_oauths DROP CONSTRAINT merchant_oauths_merchant_id_fkey;
ALTER TABLE payments.merchant_oauths ADD CONSTRAINT fk_merchant_oauths_on_merchants FOREIGN KEY (uid) REFERENCES payments.merchants (uid) ON DELETE CASCADE;

CREATE OR REPLACE FUNCTION payments.func_merchant_oauths_payback_651() RETURNS TRIGGER AS
$$
BEGIN
    IF (NEW.uid IS NULL) THEN
        NEW.uid := NEW.merchant_id::bigint;
    END IF;
    IF (NEW.merchant_id IS NULL) THEN
        NEW.merchant_id := NEW.uid::text;
    END IF;
    RETURN NEW;
END
$$ LANGUAGE plpgsql;

CREATE TRIGGER trig_merchant_oauths_payback_651 BEFORE INSERT ON payments.merchant_oauths FOR EACH ROW EXECUTE PROCEDURE payments.func_merchant_oauths_payback_651();

CREATE UNIQUE INDEX merchant_oauths_merchant_id_mode ON payments.merchant_oauths (merchant_id, mode);
ALTER TABLE payments.merchant_oauths DROP CONSTRAINT merchant_oauths_pkey;
ALTER TABLE payments.merchant_oauths ADD PRIMARY KEY (uid, mode);

ALTER TABLE payments.merchant_oauths ADD COLUMN shop_id bigint;
CREATE UNIQUE INDEX merchant_oauths_uid_shop_id_idx on payments.merchant_oauths (uid, shop_id);
