create type payments.functionality_type as enum (
    'payments',
    'yandex_pay'
);

create table payments.functionalities (
    uid bigint not null references payments.merchants (uid),
    functionality_type payments.functionality_type not null,
    data jsonb not null,
    created timestamptz not null default now(),
    updated timestamptz not null default now(),
    PRIMARY KEY (uid, functionality_type)
);

insert into payments.functionalities (uid, functionality_type, data, created) select uid, 'payments', '{"type": "payments"}'::jsonb, created from payments.merchants;
