CREATE OR REPLACE FUNCTION code.enable_organization(
    i_org_id        code.org_id
) RETURNS void AS $$
BEGIN
    PERFORM *
       FROM auditlog.organizations
      WHERE org_id = i_org_id;

    IF found THEN
        UPDATE auditlog.organizations
           SET state = 'active',
               doom_date = NULL
         WHERE org_id = i_org_id;
    ELSE
        INSERT INTO auditlog.organizations (org_id, state)
        VALUES (i_org_id, 'active')
        ON CONFLICT DO NOTHING;
    END IF;
END
$$ LANGUAGE plpgsql;
