CREATE OR REPLACE FUNCTION code.remove_disabled_organization(
    i_org_id        code.org_id,
    i_now           timestamptz
) RETURNS bigint AS $$
    WITH deleted AS (
        DELETE FROM auditlog.organizations
         WHERE state = 'disabled' AND org_id = i_org_id AND doom_date < i_now
     RETURNING 1
    )
    SELECT COUNT(*)
      FROM deleted;
$$ LANGUAGE sql;
