CREATE OR REPLACE FUNCTION code.add_events(
    i_events    code.raw_event[]
) RETURNS void AS $$
    INSERT INTO auditlog.events (org_id, uid, type, date, json)
    SELECT e.org_id, e.uid, e.type, to_timestamp(e.date), e.json::jsonb
      FROM unnest(i_events) AS e
        ON CONFLICT DO NOTHING;
$$ LANGUAGE sql;
