from mail.devpack.lib.components.postgres import Postgres


class AuditlogDb(Postgres):
    NAME = "auditlogdb"

    before_all_prefixes = [
        'resfs/file/mail/pg/auditlogdb/devpack/extensions.sql',
    ]

    after_all_prefixes = [
        'resfs/file/mail/pg/auditlogdb/code',
        'resfs/file/mail/pg/auditlogdb/grants',
        'resfs/file/mail/pg/auditlogdb/devpack/grants.sql',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/auditlogdb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/auditlogdb/auditlog.sql',
    ]

    def __init__(self, env, _):
        users = [
            'auditlogdb',
            'auditlog',
            'tech',
        ]
        self.init_from_conf(env.get_config(), 'auditlogdb', users)
