CREATE SCHEMA IF NOT EXISTS auditlog;

CREATE TYPE auditlog.organization_state AS ENUM (
    'active',
    'disabled'
);

CREATE TABLE auditlog.organizations (
    org_id     bigint                      NOT NULL PRIMARY KEY,
    state      auditlog.organization_state NOT NULL,
    created    timestamptz                 NOT NULL DEFAULT current_timestamp,
    doom_date  timestamptz,

    CONSTRAINT doom_date_only_on_disabled CHECK (
           (state = 'active'   AND doom_date IS NULL)
        OR (state = 'disabled' AND doom_date IS NOT NULL)
    )
);

CREATE TABLE auditlog.users (
    org_id     bigint      NOT NULL,
    uid        bigint      NOT NULL,
    login      text        NOT NULL,
    created    timestamptz NOT NULL DEFAULT current_timestamp,
    disabled   timestamptz,

    
    CONSTRAINT pk_users PRIMARY KEY (org_id, uid),
    CONSTRAINT fk_users FOREIGN KEY (org_id) REFERENCES auditlog.organizations ON DELETE CASCADE
);

CREATE TABLE auditlog.events (
    org_id     bigint      NOT NULL,
    uid        bigint      NOT NULL,
    type       text        NOT NULL,
    date       timestamptz NOT NULL,
    json       jsonb       NOT NULL,

    CONSTRAINT pk_events PRIMARY KEY (org_id, uid, type, date, json),
    CONSTRAINT fk_events FOREIGN KEY (org_id) REFERENCES auditlog.organizations ON DELETE CASCADE
);
