CREATE OR REPLACE FUNCTION impl.purge (
    i_count integer,
    i_user text,
    i_cutoff TIMESTAMPTZ
)
RETURNS bigint AS $$
    WITH deleted AS (
        DELETE FROM cachedb.cache
         WHERE (uid, key) in (
            SELECT uid, key
              FROM cachedb.cache
             WHERE created <= i_cutoff AND db_user = i_user
             LIMIT i_count
        )
        RETURNING 1
    )
    SELECT count(*)
      FROM deleted;
$$ LANGUAGE sql;
