from mail.devpack.lib.components.postgres import Postgres


class CacheDb(Postgres):
    NAME = "cachedb"

    before_all_prefixed = [
        'resfs/file/mail/pg/cachedb/drops'
    ]

    after_all_prefixes = [
        'resfs/file/mail/pg/cachedb/migrations',
        'resfs/file/mail/pg/cachedb/code',
        'resfs/file/mail/pg/cachedb/grants'
    ]

    def __init__(self, env, _):
        users = [
            'cachedb',
            'sendbernar',
            'xeno'
        ]
        self.init_from_conf(env.get_config(), 'cachedb', users)
