CREATE SCHEMA IF NOT EXISTS cachedb;


CREATE TABLE cachedb.cache (
    uid BIGINT NOT NULL,
    key TEXT NOT NULL,
    value TEXT NOT NULL,
    created TIMESTAMP NOT NULL DEFAULT current_timestamp,
    version TEXT NOT NULL,
    db_user TEXT DEFAULT CURRENT_USER,
    
    CONSTRAINT pk PRIMARY KEY (uid, key, version)
);

CREATE INDEX uk_cache_created
    ON cachedb.cache (uid, created)
;