ALTER TABLE event_layer
    ADD COLUMN event_start_ts TIMESTAMP,
    ADD COLUMN event_end_ts TIMESTAMP,
    ADD COLUMN repetition_due_ts TIMESTAMP;

ALTER TABLE event_resource
    ADD COLUMN event_start_ts TIMESTAMP,
    ADD COLUMN event_end_ts TIMESTAMP,
    ADD COLUMN repetition_due_ts TIMESTAMP;

CREATE INDEX i_event_layer_layer_id_event_end_ts_event_start_ts
    ON event_layer (layer_id, event_end_ts, event_start_ts)
    WHERE repetition_due_ts IS NULL;

CREATE INDEX i_event_layer_layer_id_repetition_due_ts_event_start_ts
    ON event_layer (layer_id, repetition_due_ts, event_start_ts)
    WHERE repetition_due_ts IS NOT NULL;

CREATE INDEX i_event_resource_resource_id_event_end_ts_event_start_ts
    ON event_resource (resource_id, event_end_ts, event_start_ts)
    WHERE repetition_due_ts IS NULL;

CREATE INDEX i_event_resource_resource_id_repetition_due_ts_event_start_ts
    ON event_resource (resource_id, repetition_due_ts, event_start_ts)
    WHERE repetition_due_ts IS NOT NULL;

