-- Asia/Novosibirsk;

UPDATE event e
SET start_ts = (CASE WHEN e.start_ts >= '2016-07-23 20:00:00' THEN e.start_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE e.start_ts END),
    end_ts = (CASE WHEN e.end_ts >= '2016-07-23 20:00:00' THEN e.end_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE e.end_ts END),
    recurrence_id = (CASE WHEN e.recurrence_id >= '2016-07-23 20:00:00' THEN e.recurrence_id AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE e.recurrence_id END)
FROM main_event me
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (e.start_ts >= '2016-07-23 20:00:00' OR e.end_ts >= '2016-07-23 20:00:00' OR e.recurrence_id >= '2016-07-23 20:00:00')
    AND me.id = e.main_event_id;

UPDATE event_notification en
SET next_send_ts = next_send_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00'
FROM event_user eu
INNER JOIN event e ON e.id = eu.event_id
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (en.next_send_ts >= '2016-07-23 20:00:00')
    AND eu.id = en.event_user_id;

UPDATE rdate r
SET start_ts = (CASE WHEN r.start_ts >= '2016-07-23 20:00:00' THEN r.start_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE r.start_ts END),
    end_ts = (CASE WHEN r.end_ts >= '2016-07-23 20:00:00' THEN r.end_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE r.end_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (r.start_ts >= '2016-07-23 20:00:00' OR r.end_ts >= '2016-07-23 20:00:00')
    AND e.id = r.event_id;

UPDATE repetition r
SET due_ts = (CASE WHEN r.due_ts >= '2016-07-23 20:00:00' THEN r.due_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE r.due_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (r.due_ts >= '2016-07-23 20:00:00')
    AND e.repetition_id = r.id;

UPDATE event_layer el
SET event_start_ts = (CASE WHEN el.event_start_ts >= '2016-07-23 20:00:00' THEN el.event_start_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE el.event_start_ts END),
    event_end_ts = (CASE WHEN el.event_end_ts >= '2016-07-23 20:00:00' THEN el.event_end_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE el.event_end_ts END),
    repetition_due_ts = (CASE WHEN el.repetition_due_ts >= '2016-07-23 20:00:00' AND el.repetition_due_ts != '2100-01-01 00:00:00' THEN el.repetition_due_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE el.repetition_due_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (el.event_start_ts >= '2016-07-23 20:00:00' OR el.event_end_ts >= '2016-07-23 20:00:00' OR el.repetition_due_ts >= '2016-07-23 20:00:00' AND el.repetition_due_ts != '2100-01-01 00:00:00')
    AND e.id = el.event_id;

UPDATE event_resource er
SET event_start_ts = (CASE WHEN er.event_start_ts >= '2016-07-23 20:00:00' THEN er.event_start_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE er.event_start_ts END),
    event_end_ts = (CASE WHEN er.event_end_ts >= '2016-07-23 20:00:00' THEN er.event_end_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE er.event_end_ts END),
    repetition_due_ts = (CASE WHEN er.repetition_due_ts >= '2016-07-23 20:00:00' AND er.repetition_due_ts != '2100-01-01 00:00:00' THEN er.repetition_due_ts AT TIME ZONE '+06:00' AT TIME ZONE '+07:00' ELSE er.repetition_due_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (er.event_start_ts >= '2016-07-23 20:00:00' OR er.event_end_ts >= '2016-07-23 20:00:00' OR er.repetition_due_ts >= '2016-07-23 20:00:00' AND er.repetition_due_ts != '2100-01-01 00:00:00')
    AND e.id = er.event_id;

UPDATE main_event me
SET last_update_ts = NOW() AT TIME ZONE 'UTC'
FROM event e
LEFT JOIN repetition r ON r.id = e.repetition_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (e.end_ts >= '2016-07-23 20:00:00' OR r.due_ts >= '2016-07-23 20:00:00' OR r.id IS NOT NULL AND r.due_ts IS NULL)
    AND e.main_event_id = me.id;

UPDATE layer l
SET coll_last_update_ts = NOW() AT TIME ZONE 'UTC'
FROM event_layer el
INNER JOIN event e ON e.id = el.event_id
INNER JOIN main_event me ON me.id = e.main_event_id
LEFT JOIN repetition r ON r.id = e.repetition_id
WHERE me.timezone_id = 'Asia/Novosibirsk'
    AND (e.end_ts >= '2016-07-23 20:00:00' OR r.due_ts >= '2016-07-23 20:00:00' OR r.id IS NOT NULL AND r.due_ts IS NULL)
    AND el.layer_id = l.id;

-- Asia/Magadan;

UPDATE event e
SET start_ts = (CASE WHEN e.start_ts >= '2016-04-23 16:00:00' THEN e.start_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE e.start_ts END),
    end_ts = (CASE WHEN e.end_ts >= '2016-04-23 16:00:00' THEN e.end_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE e.end_ts END),
    recurrence_id = (CASE WHEN e.recurrence_id >= '2016-04-23 16:00:00' THEN e.recurrence_id AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE e.recurrence_id END)
FROM main_event me
WHERE me.timezone_id = 'Asia/Magadan'
    AND (e.start_ts >= '2016-04-23 16:00:00' OR e.end_ts >= '2016-04-23 16:00:00' OR e.recurrence_id >= '2016-04-23 16:00:00')
    AND me.id = e.main_event_id;

UPDATE event_notification en
SET next_send_ts = next_send_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00'
FROM event_user eu
INNER JOIN event e ON e.id = eu.event_id
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (en.next_send_ts >= '2016-04-23 16:00:00')
    AND eu.id = en.event_user_id;

UPDATE rdate r
SET start_ts = (CASE WHEN r.start_ts >= '2016-04-23 16:00:00' THEN r.start_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE r.start_ts END),
    end_ts = (CASE WHEN r.end_ts >= '2016-04-23 16:00:00' THEN r.end_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE r.end_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (r.start_ts >= '2016-04-23 16:00:00' OR r.end_ts >= '2016-04-23 16:00:00')
    AND e.id = r.event_id;

UPDATE repetition r
SET due_ts = (CASE WHEN r.due_ts >= '2016-04-23 16:00:00' THEN r.due_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE r.due_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (r.due_ts >= '2016-04-23 16:00:00')
    AND e.repetition_id = r.id;

UPDATE event_layer el
SET event_start_ts = (CASE WHEN el.event_start_ts >= '2016-04-23 16:00:00' THEN el.event_start_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE el.event_start_ts END),
    event_end_ts = (CASE WHEN el.event_end_ts >= '2016-04-23 16:00:00' THEN el.event_end_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE el.event_end_ts END),
    repetition_due_ts = (CASE WHEN el.repetition_due_ts >= '2016-04-23 16:00:00' AND el.repetition_due_ts != '2100-01-01 00:00:00' THEN el.repetition_due_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE el.repetition_due_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (el.event_start_ts >= '2016-04-23 16:00:00' OR el.event_end_ts >= '2016-04-23 16:00:00' OR el.repetition_due_ts >= '2016-04-23 16:00:00' AND el.repetition_due_ts != '2100-01-01 00:00:00')
    AND e.id = el.event_id;

UPDATE event_resource er
SET event_start_ts = (CASE WHEN er.event_start_ts >= '2016-04-23 16:00:00' THEN er.event_start_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE er.event_start_ts END),
    event_end_ts = (CASE WHEN er.event_end_ts >= '2016-04-23 16:00:00' THEN er.event_end_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE er.event_end_ts END),
    repetition_due_ts = (CASE WHEN er.repetition_due_ts >= '2016-04-23 16:00:00' AND er.repetition_due_ts != '2100-01-01 00:00:00' THEN er.repetition_due_ts AT TIME ZONE '+10:00' AT TIME ZONE '+11:00' ELSE er.repetition_due_ts END)
FROM event e
INNER JOIN main_event me ON me.id = e.main_event_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (er.event_start_ts >= '2016-04-23 16:00:00' OR er.event_end_ts >= '2016-04-23 16:00:00' OR er.repetition_due_ts >= '2016-04-23 16:00:00' AND er.repetition_due_ts != '2100-01-01 00:00:00')
    AND e.id = er.event_id;

UPDATE main_event me
SET last_update_ts = NOW() AT TIME ZONE 'UTC'
FROM event e
LEFT JOIN repetition r ON r.id = e.repetition_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (e.end_ts >= '2016-04-23 16:00:00' OR r.due_ts >= '2016-04-23 16:00:00' OR r.id IS NOT NULL AND r.due_ts IS NULL)
    AND e.main_event_id = me.id;

UPDATE layer l
SET coll_last_update_ts = NOW() AT TIME ZONE 'UTC'
FROM event_layer el
INNER JOIN event e ON e.id = el.event_id
INNER JOIN main_event me ON me.id = e.main_event_id
LEFT JOIN repetition r ON r.id = e.repetition_id
WHERE me.timezone_id = 'Asia/Magadan'
    AND (e.end_ts >= '2016-04-23 16:00:00' OR r.due_ts >= '2016-04-23 16:00:00' OR r.id IS NOT NULL AND r.due_ts IS NULL)
    AND el.layer_id = l.id;

DELETE FROM resource_schedule;
