CREATE TABLE mailer_event (
    uid BIGINT NOT NULL,
    external_id TEXT NOT NULL,
    instance_id BIGINT NOT NULL,

    start_ts TIMESTAMP NOT NULL,
    end_ts TIMESTAMP NOT NULL,
    is_all_day BOOLEAN NOT NULL,

    repetition JSONB,
    recurrence_id TIMESTAMP,
    timezone_id TEXT NOT NULL,

    name TEXT NOT NULL,
    description TEXT,
    location TEXT,
    url TEXT,

    organizer JSONB,
    attendees JSONB NOT NULL,

    sequence INTEGER NOT NULL,
    dtstamp TIMESTAMP NOT NULL,

    created TIMESTAMP NOT NULL,
    modified TIMESTAMP NOT NULL,

    CONSTRAINT pk_mailer_event PRIMARY KEY (uid, external_id, instance_id),

    CONSTRAINT check_mailer_event_external_id_length CHECK (char_length(external_id) <= 512)
);
