CREATE EXTENSION IF NOT EXISTS intarray ;

ALTER TABLE user_groups
    ADD COLUMN groups INTEGER[] NOT NULL DEFAUlT '{}',
    ADD COLUMN resources_can_access INTEGER[] NOT NULL DEFAULT '{}',
    ADD COLUMN resources_can_admin INTEGER[] NOT NULL DEFAULT '{}';


ALTER TABLE user_groups ADD CONSTRAINT
    groups_unique_values CHECK (array_length(uniq(sort(groups)), 1) = array_length(groups, 1));
ALTER TABLE user_groups ADD CONSTRAINT
    resources_can_access_unique CHECK (array_length(uniq(sort(resources_can_access)), 1) = array_length(resources_can_access, 1));
ALTER TABLE user_groups ADD CONSTRAINT
    resources_can_admin_unique CHECK (array_length(uniq(sort(resources_can_admin)), 1) = array_length(resources_can_admin, 1));

CREATE FUNCTION convert_to_array(mask BIGINT) RETURNS INTEGER[] AS $$
    DECLARE
      result INTEGER[] := '{}';
      i INTEGER := 0;

    BEGIN
      LOOP
      EXIT WHEN i = 64;
        IF (mask >> i) & 1 THEN
          result := result || i;
        END IF;
        i := i + 1;
      END LOOP;
      return result;
    END;
$$ LANGUAGE plpgsql IMMUTABLE;

UPDATE user_groups SET groups = convert_to_array(groups_mask);
UPDATE user_groups SET resources_can_access = convert_to_array(resources_can_access_mask);
UPDATE user_groups SET resources_can_admin = convert_to_array(resources_can_admin_mask);
