WITH new_fields AS (
    SELECT '{
      "middle_name": null,
      "position_ru": "",
      "position_en": "",
      "gender": "MALE",
      "work_phone": null,
      "phones": []
    }'::JSONB
)
UPDATE cerberus.users
    SET info = (TABLE new_fields) ||
       jsonb_insert(
           info,
           '{"traits"}',
           to_jsonb(
               array_remove(
                   ARRAY[
                       CASE WHEN (info ->> 'robot')::boolean THEN 'ROBOT' END,
                       CASE WHEN (info ->> 'dismissed')::boolean THEN 'DISMISSED' END,
                       CASE WHEN (info ->> 'deleted')::boolean THEN 'DELETED' END,
                       CASE WHEN (info ->> 'homeworker')::boolean THEN 'HOMEWORKER' END
                   ],
                   null
               )
           )
       )
WHERE type = 'YT';
