CREATE TABLE cerberus.group_roles
(
    group_id   BIGINT NOT NULL,
    group_type TEXT   NOT NULL,
    role_id    BIGINT NOT NULL REFERENCES cerberus.roles (id) ON DELETE CASCADE,

    FOREIGN KEY (group_id, group_type) REFERENCES cerberus.groups (id, type) ON DELETE CASCADE,
    UNIQUE (group_id, group_type, role_id)
);

CREATE TABLE cerberus.user_roles
(
    uid     BIGINT NOT NULL REFERENCES cerberus.users (uid) ON DELETE CASCADE,
    role_id BIGINT NOT NULL REFERENCES cerberus.roles (id) ON DELETE CASCADE,

    UNIQUE (uid, role_id)
);

CREATE TABLE cerberus.user_groups
(
    uid        BIGINT NOT NULL REFERENCES cerberus.users (uid) ON DELETE CASCADE,
    group_id   BIGINT NOT NULL,
    group_type TEXT   NOT NULL,

    FOREIGN KEY (group_id, group_type) REFERENCES cerberus.groups (id, type) ON DELETE CASCADE,
    UNIQUE (uid, group_id, group_type)
);
